// For standart Quake3 renderer (r_ppl = 0)

_replace.vsh
{
	#if defined(CLIP)
		varying vec3	v_clipVertex;
	#endif
	varying vec4	color;
	varying vec2	texCoord;
	include colorGen.inc
	include tcGen.inc
	include deforms.inc
	void main(void)
	{
		vec4 glVertex = DeformGeometry();
		color = colorGen(glVertex);
		tcGen(texCoord, glVertex);
		gl_Position = gl_ModelViewProjectionMatrix * glVertex;
		include clipVertex.inc
	}
}

_replace.fsh
{
	uniform sampler2D	u_ColorMap;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
		varying vec3	v_clipVertex;
	#endif
	varying vec4		color;
	varying vec2		texCoord;
	void main(void)
	{
		include clipPlane.inc
		gl_FragColor = color * texture2D(u_ColorMap, texCoord);
	}
}

_add.vsh
{
	include multitexture.vsh
}

_add.fsh
{
	uniform sampler2D	u_ColorMap0;
	uniform sampler2D	u_ColorMap1;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
		varying vec3	v_clipVertex;
	#endif
	varying vec4		color;
	varying vec4		texCoords;
	void main(void)
	{
		include clipPlane.inc
		gl_FragColor = color * texture2D(u_ColorMap0, texCoords.xy) + texture2D(u_ColorMap1, texCoords.zw);
	}
}

_modulate.vsh
{
	include multitexture.vsh
}

_modulate.fsh
{
	uniform sampler2D	u_ColorMap0;
	uniform sampler2D	u_ColorMap1;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
		varying vec3	v_clipVertex;
	#endif
	varying vec4		color;
	varying vec4		texCoords;
	void main(void)
	{
		include clipPlane.inc
		gl_FragColor = color * texture2D(u_ColorMap0, texCoords.xy) * texture2D(u_ColorMap1, texCoords.zw);
	}
}

_interpolate.vsh
{
	include multitexture.vsh
}

_interpolate.fsh
{
	uniform sampler2D	u_ColorMap0;
	uniform sampler2D	u_ColorMap1;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
		varying vec3	v_clipVertex;
	#endif
	varying vec4		color;
	varying vec4		texCoords;
	vec3			sample0;
	vec4			sample1;
	float			alpha;
	void main(void)
	{
		include clipPlane.inc
		sample0 = texture2D(u_ColorMap0, texCoords.xy).rgb;
		sample1 = texture2D(u_ColorMap1, texCoords.zw);
		alpha = sample1.a * color.a;
		gl_FragColor = vec4(color.rgb * mix(sample0, sample1.rgb, alpha), 1.0);
	}
}

_interpolate_at.vsh
{
	include multitexture.vsh
}

_interpolate_at.fsh
{
	uniform sampler2D	u_ColorMap0;
	uniform sampler2D	u_ColorMap1;
	#if defined(CLIP)
		uniform vec4	u_clipPlane;
		varying vec3	v_clipVertex;
	#endif
	varying vec4		color;
	varying vec4		texCoords;
	vec3			sample0;
	vec4			sample1;
	float			alpha;
	void main(void)
	{
		include clipPlane.inc
		sample0 = texture2D(u_ColorMap0, texCoords.xy).rgb;
		sample1 = texture2D(u_ColorMap1, texCoords.zw);
		alpha = sample1.a * color.a;
		gl_FragColor = vec4(color.rgb * mix(sample0, sample1.rgb, alpha * step(0.5, alpha)), 1.0);
	}
}
